// 技術同人誌用テンプレート ver 0.2
// kanata
//--------------------
//      import
// https://typst.app/universe
//--------------------
// https://typst.app/universe/package/codelst
#import "@preview/codelst:2.0.2": sourcecode
// https://typst.app/universe/package/gentle-clues/
#import "@preview/gentle-clues:1.2.0": *
//--------------------
//     ページ設定
// https://typst.app/docs/reference/layout/page/
//--------------------
#set page(
    paper: "a5",    // 用紙サイズ
    flipped: false, // 用紙の向き（縦）
    binding: left,  // ページの綴じ（技術書は左綴じ）
    margin: (       // 余白設定
      top: 15mm,    // 上余白(天)
      bottom: 15mm, // 下余白(地)
      inside: 20mm, // ページ内側の余白(のど、とじしろ)
      outside: 12mm // ページ外側の余白(小口)
    ),
    columns: 1,     // 段組み
    numbering: "1", // ページ番号（ノンブル）
    number-align: center // ページ番号（ノンブル）の位置
)
//--------------------
//    フォント設定
// https://typst.app/docs/reference/text/text/
//--------------------
#set text(
    // 記載の順にフォントを検索します
    font: ("Meiryo UI","Yu Gothic","Arial"), // フォント設定
    /* フォント候補
      "Arial","New Computer Modern","Tahoma",
      "Times New Roman","Verdana",
      "Meiryo","Meiryo UI",
      "Yu Gothic","Yu Gothic UI","Yu Mincho",
    */
    size: 9pt,         // フォントサイズ
    lang: "jp"         // 言語
)
// コードブロック内のフォント指定
#show raw: set text(font: ("Lucida Console","Meiryo UI","Yu Gothic"))
/* コードブロック内のフォント候補（等幅フォント推奨）
  "BIZ UDGothic","Consolas","Lucida Console",
  "MS Gothic",
*/
//--------------------
//      段落設定
// https://typst.app/docs/reference/model/par/
//--------------------
#set par(
    leading: 0.8em,   // 行間
    justify: true,   // 両端揃え
    linebreaks: auto, // 改行の判断方法
    first-line-indent: 1em // 段落の最初の行のインデント
)
// 段落の最初の行がインデントされない問題への対応
// Typst最初の段落の字下げの調整方法 <https://zenn.dev/mkpoli/articles/34a5ea47468979>
#show heading: it => {
    it
    par(text(size: 0pt, ""))
}
//--------------------
//     見出し設定
// https://typst.app/docs/reference/layout/block/
//--------------------
// 章、節、項の自動採番
//#set heading(
//    numbering: " 1.1.1 ",
//)
// 章の見た目をカスタマイズする
//#show heading.where(level: 1): block.with(
//  width: 100%,
//  stroke: (
//    left: (thickness: 6pt, paint: luma(110), cap: "butt") ,
//    bottom:(thickness: 0.8pt, paint: luma(140), cap: "butt"),
//  ),
//  inset: 5pt,
//)
// 節の見た目をカスタマイズする
#show heading.where(level: 2): block.with(
  width: 100%,
  stroke: (
    left: (thickness: 6pt, paint: luma(140), cap: "butt") ,
    bottom:(thickness: 0.8pt, paint: luma(170), cap: "butt"),
  ),
  inset: 5pt,
)
// 項の見た目をカスタマイズする
#show heading.where(level: 3): block.with(
  width: 100%,
  stroke: (
    //left: (thickness: 6pt, paint: luma(140), cap: "butt") ,
    bottom:(thickness: 0.8pt, paint: luma(120), cap: "butt",/*dash: "densely-dashed",*/),
  ),
  inset: 4pt,
)
//--------------------
//    PDFメタデータ
// https://typst.app/docs/reference/model/document/
//--------------------
#set document(
    title: "ほげほげほげほげほげほげ（書籍タイトル）", // タイトル
    author: "Your name", // 著者
    date: auto // 日付
)

//--------------------
//      タイトル
//--------------------

\ \ \
#align(center)[
  #text(
    font: "Meiryo UI", // フォント
    size: 18pt,        // フォントサイズ
    lang: "jp"         // 言語
  )[*ほげほげほげほげほげほげ（書籍タイトル）*]
  \ \
  #text(
    font: "Meiryo UI", // フォント
    size: 13pt,        // フォントサイズ
    lang: "jp"         // 言語
  )[*ふがふがふがふが（書籍サブタイトル）*]
  \ \
  #text(
    font: "Meiryo UI", // フォント
    size: 13pt,        // フォントサイズ
    lang: "jp"         // 言語
  )[Your name]
]

#pagebreak()

//--------------------
//       目次
//--------------------
#show outline.entry.where(
  level: 1
): it => {
  v(14pt, weak: true)
  strong(it)
}

#outline(
    title: "目次",
    depth: 3,
    indent: 2em
)

//--------------------
//       本文
//--------------------






//--------------------
//        奥付
//--------------------
\ \ \ \ \ \ \ \ \ \ \ \ // 改行で奥付の位置調整
#text(
    font: "Meiryo UI", // フォント
    size: 12pt,        // フォントサイズ
    lang: "jp"         // 言語
)[ほげほげほげほげほげほげ（書籍タイトル）]
#line(length:38em,stroke:1pt) // 罫線
#table(
  columns: (6em,auto),
  stroke: none,
  table.cell(colspan: 2)[2099年99月99日  初版発行],
  [],[],
  [発行者],[Your company],
  [著者], [Your name],
  [連絡先],[𝕏(旧Twitter): \@Your ID],
  [印刷会社],[ほげほげ出版],
)
#line(length:38em,stroke:1pt) // 罫線


//--------------------
//      sample
//--------------------

= サンプル

= 見出し1
== 見出し2
=== 見出し3
==== 見出し4

- コードブロック

```c
    #include <stdio.h>

    int main() {
        printf("Hello, World!\n");
        return 0;
    }
```

- コードブロック

#sourcecode[```c
    #include <stdio.h>

    int main() {
        printf("Hello, World!\n");
        return 0;
    }
```]

- 箇条書き

+ 数字連番の箇条書き
  - 黒点の箇条書き
+ 数字連番の箇条書き
  - 黒点の箇条書き
+ 数字連番の箇条書き
  - 黒点の箇条書き

- 説明

/ 用語: 説明

- 強調

*こんな感じ*になります

- 斜体

_こんな感じabc_ abcになります

- コメント

```
/* hoge */または// hoge
```

- 表

#figure(
  table(
    columns: (1fr, auto, auto),
    inset: 10pt,
    align: horizon,
    table.header(
      [], [*Area*], [*Parameters*],
    ),
    "テストA",
    $ pi h (D^2 - d^2) / 4 $,
    [
      $h$: height \
      $D$: outer radius \
      $d$: inner radius
    ],
    "テストB",
    $ sqrt(2) / 12 a^3 $,
    [$a$: edge length]
  ),
  caption: [ 表の名称とかを書く ],
  kind: "table",
  supplement: [表]
)

- 画像

#figure(
  image("figure.png", width: 50%),
  caption: [ 画像の説明とかを書く ],
    kind: "image",
  supplement: [図]
)

- 脚注

メロスは激怒した。#footnote[なおこの後セリヌンティウスがとばっちりを受けます]必ず、

- gentle-clues

#info[ テスト ... ] 
#tip(title: "テスト１")[テスト２]
#clue(title: "テスト３", icon: none, accent-color: orange)[テスト４]
