// 「Typstで技術同人誌を書く。」 touying スライドサンプル
// kanata
#import "@preview/touying:0.5.5": * // touyingのimport
// touyingのテーマ設定
// https://touying-typ.github.io/docs/category/themes
#import themes.simple: * // Simple Theme

//--------------------
//   グローバル設定
//--------------------
#show: simple-theme.with(aspect-ratio: "16-9") // "16-9" または "4-3" を指定
#set text(
  font: ("Meiryo UI", "Yu Gothic", "Arial"), // フォント設定
  lang: "jp" // 言語
)
// コードブロック内のフォント指定
#show raw: set text(font: ("Lucida Console", "Meiryo UI", "Yu Gothic"))

// 色の調整
// 参考: https://forum.typst.app/t/touying-how-to-change-color-of-title-slide/2071
#show: touying-set-config.with(
  config-colors(
    primary: black // 強調表示の色変更（濃い青色→黒色）
  )
)

//--------------------
//       本文
//--------------------
// タイトル
#align(center)[
  #text(
    font: "Georgia", // フォント
    size: 5.5em, // フォントサイズ
    lang: "jp", // 言語
  )[Typst]
  #text(
    font: "Georgia", // フォント
    size: 1.5em, // フォントサイズ
    lang: "jp", // 言語
  )[*でスライドを作る。*]
]

// 目次
#pagebreak()
#components.adaptive-columns(outline(title: "目次", indent: 1em))

// 目次用に記載するが、スライドには表示しない
#hide()[= Typstでスライドを作る。]

== はじめに🫧

と、いうわけでTypst#text(size:1.5em)[*で*]スライドを作ろうと決意したのですが、けっこう良かったので、その良さをおすそ分けしようと思い、スライドのサンプルについて書くことにしました#footnote[プレゼンテーションでは使いにくいかもしれませんが、脚注もこのように表現できます。]。

#v(25pt)
#align(center)[
これまで解説したTypstの文法でスライドが作れます\ 
#text(size: 1.4em)[*追加でおぼえることはほぼありません!*]
]

== サンプル📝

#grid(
    columns:(auto,auto),
    inset: 5pt,
    [=== コードサンプル
      #import "@preview/codelst:2.0.2": sourcecode
      #sourcecode()[```Typst
      // 以下2行記載すれば使えます
      #import "@preview/touying:0.5.5": *
      #import themes.simple: *
      ```]
      - 箇条書きもこの通り書けます
      - このファイルを基に適宜修正して利用できます
    ],
    [=== 画像サンプル
      #image("figure.jpg",width: 95%)
    ]
)



