#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <sys/ptrace.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

pid_t signal_pid;

/* シグナルハンドラ */
void signal_handler(int signum, siginfo_t *info, void *ctx){
  ptrace(PTRACE_DETACH,signal_pid,NULL,NULL);
  exit(EXIT_SUCCESS);
}

int main( int argc ,char *argv[] )
{
  pid_t pid;
  int status;
  struct timespec interval;
  struct sigaction signal;


  /* 引数の取得 */
  if( argc < 3 ){
    printf("Usage:\n");
    printf("  # %s pid interval(nanosec)\n\n",argv[0]);
    exit(1);
  }
  pid = atoi(argv[1]);
  interval.tv_sec  = 0;
  interval.tv_nsec = atol(argv[2]);
  if( interval.tv_nsec == 0 ){
    printf("Usage:\n");
    printf("  # %s pid interval(nanosec)\n\n",argv[0]);
    exit(1);
  }

  /* シグナルハンドラ設定 */
  memcpy(&signal_pid,&pid,sizeof(pid_t));
  memset(&signal,0x00,sizeof(sigaction));
  signal.sa_sigaction = signal_handler;
  signal.sa_flags = SA_RESTART | SA_SIGINFO;

  if (sigaction(SIGINT, &signal, NULL) < 0) {
    fprintf(stderr,"Failed to sigaction\n");
    exit(2);
  }

  /* 対象プロセスのATTACH */
  if(ptrace(PTRACE_ATTACH,pid,NULL,NULL) != 0 ){
    fprintf(stderr,"Failed to attach (pid: %d)\n",pid);
    exit(1);
  }
  
  printf("Now to be slowing... If you will stop for slow, press Ctrl + c\n");
  while(1){
    if(waitpid(pid,&status,0) < 0 ){ /* ATTACH の完了を待つ */
      fprintf(stderr,"Failed to waitpid (pid: %d) %s\n",pid,strerror(errno));
      exit(1);
    }
    if(WIFEXITED(status))break;
    if(ptrace(PTRACE_SINGLESTEP,pid,0,NULL) != 0 ){
      fprintf(stderr,"Failed to single step (pid: %d) %s\n",pid,strerror(errno));
      exit(1);
    }
    nanosleep(&interval,NULL);
  }

  ptrace(PTRACE_DETACH,pid,NULL,NULL);
  return EXIT_SUCCESS;
}
