#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ptrace.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/user.h>

void dump_reg(long long int reg,char *name);

int main( int argc ,char *argv[] )
{
  pid_t pid;
  struct user_regs_struct regs;

  /* 引数の取得 */
  if( argc < 2 ){
    printf("Usage:\n");
    printf("  # %s pid \n\n",argv[0]);
    exit(1);
  }
  pid = atoi(argv[1]);

  /* 読み出し対象のトレース状態化と/porc/<PID>/memのオープン */
  if(ptrace(PTRACE_ATTACH,pid,NULL,NULL) != 0 ){
    fprintf(stderr,"Failed to attach (pid: %d)\n",pid);
    exit(1);
  }
  if(waitpid(pid,NULL,0) < 0 ){ /* ATTACH の完了を待つ */
    fprintf(stderr,"Failed to waitpid (pid: %d)\n",pid);
    exit(1);
  }

  if( ptrace(PTRACE_GETREGS, pid, 0, &regs) != 0 ){
    fprintf(stderr,"Failed to access registers (pid: %d)\n",pid);
    exit(1);
  }


  dump_reg(regs.rax,"rax");
  dump_reg(regs.orig_rax,"orig_rax");
  dump_reg(regs.rbx,"rbx");
  dump_reg(regs.rcx,"rcx");
  dump_reg(regs.rdx,"rdx");

  dump_reg(regs.rbp,"rbp");
  dump_reg(regs.rip,"rip");
  dump_reg(regs.rsp,"rsp");

  dump_reg(regs.rsi,"rsi");
  dump_reg(regs.rdi,"rdi");

  dump_reg(regs.r8,"r8");
  dump_reg(regs.r9,"r9");
  dump_reg(regs.r10,"r10");
  dump_reg(regs.r11,"r11");
  dump_reg(regs.r12,"r12");
  dump_reg(regs.r13,"r13");
  dump_reg(regs.r14,"r14");
  dump_reg(regs.r15,"r15");

  dump_reg(regs.eflags,"eflags");

  dump_reg(regs.cs,"cs");
  dump_reg(regs.ss,"ss");
  dump_reg(regs.ds,"ds");
  dump_reg(regs.es,"es");
  dump_reg(regs.fs,"fs");
  dump_reg(regs.gs,"gs");
  dump_reg(regs.fs_base,"fs_base");
  dump_reg(regs.gs_base,"gs_base");

  ptrace(PTRACE_DETACH,pid,NULL,NULL);
  return EXIT_SUCCESS;
}

void dump_reg(long long int reg,char *name){
  int  i;
  unsigned char disp_ascii_word;
  unsigned char disp_ascii_digit[17];
  unsigned char disp_ascii_work[3];
  unsigned char disp_ascii[9];

  memset(disp_ascii,'\0',sizeof(disp_ascii));

  memset(disp_ascii_digit,'\0',sizeof(disp_ascii_digit));
  memset(disp_ascii_work,'\0',sizeof(disp_ascii_work));
  sprintf(disp_ascii_digit,"%016lx",reg);

  for( i = 0 ; i < 8 ; i++ ){
    memcpy(&disp_ascii_work,&disp_ascii_digit[i*2],2);
    disp_ascii_word = (unsigned char)strtol(disp_ascii_work,NULL,16);
    if(disp_ascii_word < 0x20 || disp_ascii_word >= 0x7F){
      disp_ascii[i] = '.';
    }else{
      disp_ascii[i] = disp_ascii_word;
    }
  }

  printf("%8s: %16lx %16ld %s\n",name,reg,reg,&disp_ascii);
}

