//----------------------------------------------------------------------------//
// Poderosa_Macro_all_term_input.js ver 0.3
// 指定した複数の端末に一度に入力を行う。
// （複数マシンで同じ作業をする必要がある時に便利）
// 2007.02.02 kanata
//----------------------------------------------------------------------------//


import Poderosa;
import Poderosa.Macro;
import Poderosa.ConnectionParam;
import Poderosa.Terminal;
import Poderosa.View;
import System;
import System.IO;
import System.Drawing;
import System.Windows.Forms;
var env = new Environment();

class MyForm extends Form
{

	var combo1 : MyTextBox;
	var text1  : Label;
	var InputKeys = "";
	
	function MyForm()
	{
		super();
		Size = new System.Drawing.Size( 520, 90 );
		Location = new Point( 200, 200 );
		StartPosition = FormStartPosition.Manual;

		// テキストフィールドの表示
		text1 = new Label();
		text1.Location = new Point( 5, 5 );
		text1.Text = "コマンドを入力";
		Controls.Add( text1 );

		// テキストボックスの場合
		combo1 = new MyTextBox();
		combo1.Width = 500;
		combo1.Location = new Point( 5, 28 );
		Controls.Add( combo1 );
		
	}
	
	// ダイアログがxを押されて閉じられたとき
	protected function CheckCloseDialog( e : FormClosingEventArgs )
	{
		// ウィンドウを閉じる
		InputKeys = "";
		MyForm( Parent ).combo1.Text = "";
		MyForm( Parent ).Close();
	}
	
	class MyTextBox extends TextBox 
	{

		protected function OnKeyUp( e : KeyEventArgs )
		{
			if ( e.KeyCode == System.Windows.Forms.Keys.Enter )
			{
				if ( MyForm( Parent ).combo1.Text.Length == 0 )
				{
					// ウィンドウを閉じる
					InputKeys = "[ENTER]";
					MyForm( Parent ).combo1.Text = "";
					MyForm( Parent ).Close();
				}
				else
				{
					// ウィンドウを閉じる
					InputKeys = MyForm( Parent ).combo1.Text;
					MyForm( Parent ).combo1.Text = "";
					MyForm( Parent ).Close();
				}
			}
		}

	}

}


all_term_input();

function all_term_input() {

	/************************/
	/* 対象ターミナルの選択 */
	/************************/
	var con : Connection[];
	con = new Connection[15];
	
	var i=0;
	var max_term=1;
	var btn_input="Yes";

	while ( btn_input == "Yes" )
	{
		btn_input = System.Windows.Forms.MessageBox.Show("選択したらＹＥＳ・選択終了はNoを押して下さい\n選択数:"+i,"対象ターミナルの選択", MessageBoxButtons.YesNo,MessageBoxIcon.Question);
		 
		if ( btn_input == System.Windows.Forms.DialogResult.Yes )
		{
			/* アクティブウィンドウのコネクションを保持 */
			btn_input = "Yes";
			con[i] = env.Connections.ActiveConnection;
			if(con==null) {
				env.Util.MessageBox("This macro requires an established connection to shell.");
				return;
			}
			i=i+1;
		}
		else
		{
			/* アクティブウィンドウ選択処理を終了 */
			btn_input = "No";
		}
	}
	
	max_term=i;

	/******************/
	/* フォームの作成 */
	/******************/
	var f : MyForm = new MyForm();
	var flag = true;
	
	/**********/
	/* ループ */
	/**********/
	while( flag == true )
	{
		// ダイアログ表示
		f.InputKeys="";
		f.ShowDialog();
		
		// 空打ちの行を認める
		if ( f.InputKeys == "[ENTER]" )
		{
			f.InputKeys="";
			// 送信
			for(i=0;max_term > i;i++)
			{
				con[i].TransmitLn(f.InputKeys);
			}
		}
		else{
			// 送信
			for(i=0;max_term > i;i++)
			{
				con[i].TransmitLn(f.InputKeys);
			}
		
			// フォームが閉じられた判定→終了
			if ( f.InputKeys.Length == 0 )
			{
				flag=false;
			}
		}
	}

}
