//----------------------------------------------------------------------------//
// Poderosa_Macro_keyboard_macro.js ver 0.2
// 指定したファイルに記述してあるものを順に実行する。
// 2007.02.26 kanata
// 
// 文法
// #・・・コメント
// #SLEEP=300・・・３００ミリ秒待機
// #RECEIVE=PASS・・・PASSという文字が出現するまで待機
//----------------------------------------------------------------------------//

import Poderosa;
import Poderosa.Macro;
import Poderosa.ConnectionParam;
import Poderosa.Terminal;
import System;
import System.IO;
import System.Drawing;
import System.Threading;
import System.Windows.Forms;

var env = new Environment();

SelectFile();

function SelectFile(){
	var dlg : OpenFileDialog = new OpenFileDialog();
	if(dlg.ShowDialog() == DialogResult.OK) CreateFile(dlg.FileName);
}

function CreateFile(filename : String) {

	var sleeptime = 100;
	var i;
	var only_filename = System.IO.Path.GetFileName(filename);
	var flag = "";		//マクロ命令分岐フラグ
	var macro_sleep = 100;
	var macro_receive = "";
	var rec = "";
	
	/*文字コード*/
	var htmlfile = GetObject(filename,"htmlfile")
	do{
		Thread.Sleep( sleeptime );
	}while( htmlfile.readyState != "complete" );
	
	var char_code = htmlfile.charset
	
	/*ファイルの読み込み処理*/
	var file_line : String[];
	file_line = File.ReadAllLines(filename,System.Text.Encoding.GetEncoding(char_code));
	
	/*アクティブコネクション取得*/
	var con = env.Connections.ActiveConnection;
	if(con==null) {
		env.Util.MessageBox("This macro requires an established connection to shell.");
		return;
	}
	
	/*ファイル作成*/
	for ( i=0 ;i < file_line.Length ; i++ ){
		
		flag=0;
		if ( -1 != file_line[i].search(/^#/i)        ) flag=1;
		if ( -1 != file_line[i].search(/^#SLEEP/i)   ) flag=2;
		if ( -1 != file_line[i].search(/^#RECEIVE/i) ) flag=3;
		
		switch (flag)
		{
			case 1:
				/* コメント行 */
				break;
			case 2:
				/* sleep命令 */
				macro_sleep = file_line[i].split("=");
				Thread.Sleep( Number(macro_sleep[1]) );
				break;
			case 3:
				/* receive命令 */
				macro_receive = file_line[i].split("=");
				while(rec.indexOf(macro_receive[1])==-1){
					rec = con.ReceiveData();
				}
				break;
			default:
				/* 文字送信 */
				con.TransmitLn( file_line[i] );
		}
		Thread.Sleep( sleeptime );
	}
}
