//----------------------------------------------------------------------------//
// Poderosa_Macro_pushdown_file.js ver 0.4
// 指定したファイルをアクティブなコネクションのカレントに作成する。
// 2007.02.21 kanata
//----------------------------------------------------------------------------//

import Poderosa;
import Poderosa.Macro;
import Poderosa.ConnectionParam;
import Poderosa.Terminal;
import System;
import System.IO;
import System.Drawing;
import System.Threading;
import System.Windows.Forms;

var env = new Environment();

SelectFile();

function SelectFile(){
	var dlg : OpenFileDialog = new OpenFileDialog();
	if(dlg.ShowDialog() == DialogResult.OK) CreateFile(dlg.FileName);
}

function CreateFile(filename : String) {

	var sleeptime = 100;
	var i;
	var only_filename = System.IO.Path.GetFileName(filename);
	var pattern;	//文字列置換用変数
	pattern = /"/g;	//文字列置換パターン
	
	/*文字コード*/
	var htmlfile = GetObject(filename,"htmlfile");
	
	do{
		Thread.Sleep( sleeptime );
	}while( htmlfile.readyState != "complete" );
	
	var char_code = htmlfile.charset;
	
	/*ファイルの読み込み処理*/
	var file_line : String[];
	file_line = File.ReadAllLines(filename,System.Text.Encoding.GetEncoding(char_code));
	
	
	/*アクティブコネクション取得*/
	var con = env.Connections.ActiveConnection;
	if(con==null) {
		env.Util.MessageBox("This macro requires an established connection to shell.");
		return;
	}
	
	/*ファイル作成*/
	for ( i=0 ;i < file_line.Length ; i++ ){
		//con.TransmitLn( "echo "+"\'"+file_line[i]+"\'"+">> "+only_filename);
		/* "でおかしくならないように文字列置換をする */
		con.TransmitLn( "echo "+"\""+file_line[i].replace(pattern,"\\\"")+"\""+">> "+only_filename);
		
		Thread.Sleep( sleeptime );
	}
	
	con.TransmitLn( "echo push file done.");
}
