//----------------------------------------------------------------------------//
// Poderosa_Macro_combo_login.js ver 0.1
// コンボボックスで選択したホストにログインする。
// 2007.02.01 kanata
//----------------------------------------------------------------------------//

import Poderosa;
import Poderosa.Macro;
import Poderosa.ConnectionParam;
import Poderosa.Terminal;
import System;
import System.IO;
import System.Drawing;
import System.Threading;
import System.Windows.Forms;

var env = new Environment();

class MyForm extends Form
{
	/* メンバ設定（５個まで） */
	/* ※ここの値をカスタマイズする */
	var login_host			= [ "192.168.10.1" , "192.168.10.2" , "192.168.10.3" , "192.168.10.4" , "192.168.10.5" ];
	var login_user			= [ "user01"       , "user01"       , "user01"       , "user01"       , "user01" ];
	var login_passwd		= [ "passwd"       , "passwd"       , "passwd"       , "passwd"       , "passwd" ];
	var login_rootpasswd	= [ "rootpass"     , "rootpass"     , "rootpass"     , "rootpass"     , "rootpass" ];

	var ctext1 = [	login_host[0]+"("+login_user[0]+")" , 
			login_host[1]+"("+login_user[1]+")" , 
			login_host[2]+"("+login_user[2]+")" , 
			login_host[3]+"("+login_user[3]+")" , 
			login_host[4]+"("+login_user[4]+")" ];
	var btn1 : MyButton;
	var combo1 : ComboBox;
	var text1  : Label;
	var select_num = "";
	
	function MyForm()
	{
		super();
		Size = new System.Drawing.Size( 170, 120 );
		Location = new Point( 200, 200 );
		StartPosition = FormStartPosition.Manual;

		// テキストフィールドの表示
		text1 = new Label();
		text1.Location = new Point( 5, 5 );
		text1.Text = "ログインホスト選択";
		Controls.Add( text1 );

		// リストボックスの場合
		combo1 = new ComboBox();
		combo1.Width = 150;
		combo1.Location = new Point( 5, 28 );
		combo1.Items.AddRange( ctext1 );
		combo1.Text = ctext1[0];
		Controls.Add( combo1 );

		// ボタン
		btn1 = new MyButton();
		btn1.Text = "open";
		btn1.Location = new Point( 5, 60 );
		Controls.Add( btn1 );
		
	}
	
	// ダイアログがxを押されて閉じられたとき
	protected function CheckCloseDialog( e : FormClosingEventArgs )
	{
		// ウィンドウを閉じる
		MyForm( Parent ).Close();
	}
	
	class MyButton extends Button 
	{
		protected function OnClick( e : EventArgs )
		{
			// ウィンドウを閉じる
			select_num = MyForm( Parent ).combo1.SelectedIndex;
			MyForm( Parent ).Close();
		}
	}
}

ssh_connection();

function ssh_connection() {

	// フォームを表示する
	var f : MyForm = new MyForm();
	f.ShowDialog();

	// フォームが閉じられた対策
	if ( f.select_num.Length == 0 )
	{
		return;
	}
	
	var param = new SSHTerminalParam( ConnectionMethod.SSH2, f.login_host[f.select_num] , f.login_user[f.select_num] ,f.login_passwd[f.select_num] );
	
	/* Encoding */
	param.Encoding = EncodingType.UTF8;
	
	/* rename tab */
	//param.Caption = tab_name;
	
	/* Cconnection Open SSH */
	var c = env.Connections.Open(param);
	
	if ( f.login_rootpasswd !== "" )
	{
		/* 100ミリ秒待機 */
		Thread.Sleep( 100 );
		
		/* suコマンド発行 */
		c.TransmitLn( "su -");
		var r = c.ReceiveData();
		
		/* パスワード入力待ち */
		while(r.indexOf("Password:")==-1){
			r = c.ReceiveData(); //waiting prompt for account
		}
		/* パスワード入力 */
		c.TransmitLn( f.login_rootpasswd[f.select_num] );
	}
}
