class AlbumController < ApplicationController
  # unloadable
  before_action :load

  # 定数宣言
  DEFAULT_DISPLAY  = '250' # 一度に表示する数
  DEFAULT_POSITION = '0' # 画像の開始位置

  def show
    # プロジェクトメニュー画面は表示する
    @project = Project.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      render_404
  end

private
  def load
    # 画像パスの一覧を取得
    #@photoListWork = Dir::glob('public/images/album/' + params[:id] + '/*.jpg' )
    @photoListWork = Dir::glob('public/plugin_assets/album/' + params[:id] + '/*.jpg' )
    @photoListWork = @photoListWork.to_a.sort{|a, b| b[/\d+/].to_i <=> a[/\d+/].to_i }

    # 画像表示の開始位置に指定が無かったら、デフォルト値を使用する
    @position  = params[:position]
    if @position.nil?
      @position = DEFAULT_POSITION
    end

    # 一度に表示する数の指定が無かったら、デフォルト値を使用する
    @display   = params[:display]
    if @display.nil?
      @display = DEFAULT_DISPLAY
    end

    # 表示する分だけ配列を抽出する
    @photoList = @photoListWork[@position.to_i,@display.to_i]

    # 次のページの計算
    @link_next = @position.to_i + @display.to_i 
    if @link_next > @photoListWork.length
      @link_next = @photoListWork.length - 1
    end

    # 前のページの計算
    @link_back = @position.to_i - @display.to_i
    if @link_back < 0
      @link_back = 0
    end

  end

end
