#!/usr/bin/env python2.7
#-*- coding: utf-8 -*-

import os
import sys
import signal
import syslog
import socket

HOST = sys.argv[1]
PORT = int(sys.argv[2])

# ソケットの作成
s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

# ソケットとIPアドレスの関連づけ
s.bind((HOST, PORT))

# クライアントとの接続の準備
s.listen(1)

# クライアントとの接続
conn, addr = s.accept()

# シスログ出力
syslog.openlog('kippoBrinkerDummyEntry.py',syslog.LOG_PID,syslog.LOG_SYSLOG)
syslog.syslog(syslog.LOG_ERR,'[WARN] doubtful access '+str(addr[0])+" ("+str(addr[1])+")")
syslog.closelog()

# 繋がった瞬間切断
conn.close()

# 親プロセスに通知
os.kill( os.getppid(), signal.SIGALRM )
