#!/bin/bash

# kippoBrinker ver 0.4
# 2015/10/24 kanata

MY_IP_ADDR=`hostname -i|head -1|cut -d' ' -f2`	# 自分のIPアドレスを設定(このIPでBINDする)
PROC_NUM="25"	# ダミーsshdを何個立ち上げるか
EXEMPT_PORT_LIST="80 443"	# ダミーsshdの対象外ポート
DUMMY_ENTRY_PORT="22"	# ダミー待ち受けポート

#------------------#
# シグナルハンドラ #
#------------------#
kippoDeploy () {
  # 既にプロセス生成されている場合は、何もしない
  NOW_PROC_NUM=`ps -ef | grep twistd|wc -l`
  if [ "${PROC_NUM}" -le "${NOW_PROC_NUM}" ]
  then
    return 0
  fi

  for i in `seq ${PROC_NUM}`
  do
    # ダミー用ポートの生成 (1～5000番のポートをランダムに設定する)
    #SSH_KIPPO_PORT=`echo $(( $(od -vAn -N4 -tu4 < /dev/random) % 5000 ))`
    SSH_KIPPO_PORT=`expr $RANDOM % 5000 + 1`
    for WORK_PORT in ${EXEMPT_PORT_LIST}
    do
      if [ "${WORK_PORT}" = "${SSH_KIPPO_PORT}" ]
      then
        #SSH_KIPPO_PORT=`echo $(( $(od -vAn -N4 -tu4 < /dev/random) % 5000 ))`
        SSH_KIPPO_PORT=`expr $RANDOM % 5000 + 1`
      fi
    done
    # ダミー用シグネチャの生成 (kippoBrinker.txtからランダムに選択する)
    L=`cat kippoBrinker.txt|wc -l`
    L=`echo $(( $(od -vAn -N4 -tu4 < /dev/random) % ${L} ))`
    L=$(( L + 1 ))
    SSH_KIPPO_SIG=`sed -n ${L}p kippoBrinker.txt`
    # configファイル生成
    sed -e "s/ssh_version_string = SSH-2.0-OpenSSH_5.1p1 Debian-5/ssh_version_string = ${SSH_KIPPO_SIG}/" kippo.cfg.dist |sed -e "s/ssh_port = 2222/ssh_port = ${SSH_KIPPO_PORT}/" > kippo.cfg
    # 起動
    #echo "Debug: dummy sshd port ${SSH_KIPPO_PORT}"
    rm -f kippo.pid
    twistd -y kippo.tac -l log/kippo.log --pidfile kippo.pid 
    rm -f kippo.pid
  done 
  # 30分後にダミーsshdは全部落とす
  sleep 30m
  pkill twistd
}

noexit () {
  :
}

#--------------#
# シグナル登録 #
#--------------#
trap kippoDeploy 14
trap noexit 1 2 3 4 15

#------------------------#
# メイン処理             #
# ダミーエントリーの制御 #
#------------------------#
while :
do
  # ダミーエントリーの起動
  if ps -ef | grep -v grep | grep "kippoBrinkerDummyEntry.py ${MY_IP_ADDR} ${DUMMY_ENTRY_PORT}" > /dev/null
  then
    :
  else
    python kippoBrinkerDummyEntry.py ${MY_IP_ADDR} ${DUMMY_ENTRY_PORT}
    # 実行失敗した場合は、ポート未開放の場合あり、3分まって再接続する
    if [ $? -ne 0 ]
    then
      pkill -9 kippoBrinkerDummyEntry.py
      sleep 3m
    fi
  fi
done

exit 0

