#!/bin/bash

# TwitterSearch ver 0.3
# 2016.11.27 kanata
# option -noimage 画像表示をしない
#
# こんな感じで監視できる
# watch -n 10 -c -d TwitterSearch.sh '地震' -noimage

SEARCH_WORD=`ruby -r cgi -e "puts CGI.escape(\""$1"\")"`

TEMP="/tmp/TwitterSearch_temp_$$"

IFS='
'

CONTENT=`curl -s "http://twinavi.jp/twitter/search/?q=${SEARCH_WORD}&or=1&ob=1"|grep -e 'twitter-search-result-name' -e 'twitter-search-result-text' -e 'twitter-search-image'|sed -e 's/^ *//g'|grep  -v 'twitter-search-imagebox.*colorbox'`

mkdir -p ${TEMP}
trap 'rm -rf ${TEMP}; exit 1' 1 2 3 11 15

for LINE in $CONTENT
do
  if   echo $LINE | grep twitter-search-result-name >/dev/null
  then
    echo -e "\e[1m" 
    echo "${LINE}" |  sed -e 's/<[^>]*>//g'
    rm -f ${TEMP}/*
  elif echo $LINE | grep twitter-search-result-text >/dev/null
  then
    printf "\e[0m"
    echo "  ${LINE}" |  sed -e 's/<[^>]*>//g'
    rm -f ${TEMP}/*
  elif echo $LINE | grep twitter-search-image >/dev/null
  then
    #if [ `echo "${@}" | grep 'noimage' >/dev/null` -a ! -z "`ls -A ${TEMP}`" ]
    #if [ ! `echo "${@}" | grep 'noimage' >/dev/null` ]
    if ! echo "${@}" | grep 'noimage' >/dev/null
    then
    if [ -z "`ls -A ${TEMP}`" ]
    then
      IMAGE_URL=`echo ${LINE} |sed 's/http/\nhttp/g'|tail -1|awk '{print $1}'|tr -d '"'`
      wget -nv ${IMAGE_URL} -P ${TEMP} 2>/dev/null
      wait
      for WORD in `ls ${TEMP}`
      do
        convert ${TEMP}/${WORD} -interlace none ${TEMP}/converted_${WORD}
      done
      echo ${IMAGE_URL}
      test -x `which cam` && cam ${TEMP}/converted_*
    fi
    fi
  else
    :
  fi

done

rm -rf ${TEMP}

exit 0
